C      *****************************************************************
C      * Function WhereIs                                              *
C      * Returns the index into the species concentration array of the *
C      * passed species name.  This is done by searching the labels    *
C      * array for the passed species name and assigning the           *
C      * corresponding index to WhereIs.  The index into the labels    *
C      * array is the same as the index into the species concentration *
C      * array.  The passed name only has to match up with the first   *
C      * part of any label (e.g. P will match PO4) except for N because*
C      * the routine NitroCheck distinguishes between N, NH4 and NO3.  *
C      * If the species is not found a -1 is returned.                 *
C      *                                                               *
C      * Variables:                                                    *
C      * J         -Local - Length of name passed to routine.          *
C      *                    Unitless.                                  *
C      * Labels    -Input - A vector, of size NSpecies, of the name for*
C      *                    each species.  Unitless.                   *
C      *                    (Common block VModel, file VModel.f)       *
C      * NSpecies  -Input - The number of species in the system (i.e.  *
C      *                    the number of components plus the number   *
C      *                    of dependent species).  Unitless.          *
C      *                    (Common block VModel, file VModel.f)       *
C      * S         -Local - Species index.  Unitless.                  *
C      *****************************************************************
       INTEGER FUNCTION WHEREIS(NAME)
							IMPLICIT NONE
							INCLUDE 'VMODEL.INC'
							CHARACTER*8 NAME
							INTEGER S, J
C      *--------------------------------------------*
C      * Initialize the function to the error value *
C      *--------------------------------------------*
	      WHEREIS = -1
	   
C      *----------------------------------------------------------------*
C      * Search the labels array for the passed species name and assign *
C      * to the function the index value found.  Note that the label    *
C      * array may contain a compound (species must be first part).     *
C      * If passed name is N look for an exact match.
C      *----------------------------------------------------------------*
       J = INDEX(NAME,'  ')
       IF (J.EQ.0) J = 8  !Assume that name is 8 chars long.
       S = 1
  100  CONTINUE	   
          IF (NAME.EQ. 'N') THEN
	            IF (LABELS(S).EQ.NAME)  WHEREIS = S
          ELSE
	            IF (LABELS(S)(:J-1).EQ.NAME)  WHEREIS = S
          ENDIF
		        S = S + 1
	      IF ((S.LE.NSPECIES).AND.(WHEREIS.EQ.-1)) GOTO 100

       RETURN
	      END
C      *****************************************************************
C      *                    END SUBROUTINE                             *
C      *****************************************************************
